<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('account_id', 'customer_id', 'source_id', 'is_confirmed', 'is_exported', 'confirmed_at', 'exported_at');

    public function account()
    {
        return $this->belongsTo('Account', 'account_id');
    }

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

    public function source()
    {
        return $this->belongsTo('Source', 'source_id');
    }

    public function documents()
    {
        return $this->hasMany('Document');
    }

    public function articles()
    {
        return $this->belongsToMany('Article')->withPivot('quantity');
    }

}